/* sccsid[] = "@(#) $Id: //bas/46C/src/proj/crfc/crfcserv.cpp#2 $ SAP" */   
//
// SAP RFC Classes C++ library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved. 

/////////////////////////////////////////////////////////////////////////////////
//  File crfcserv.cpp
/////////////////////////////////////////////////////////////////////////////////

#include "sapitab.h"
#include "saprfc.h"
            
#include "crfcserv.h"
#include "crfcconn.h"
#include "crfcsapp.h"
#include "crfcgfit.h"
                                                                
extern CRfcTrace RfcClassTrace;

#include <stdio.h>

//////////////////////////////////////////////////////////////////////////////////
//    CRfcServerFunc Implementations                               

/*CRfcServerFunc::CRfcServerFunc (CSTR strFunctionName) 
                      :CRfcFunction (NULL, strFunctionName),
                       m_pServerApp(NULL)
{
}*/


	CRfcServerFunc::CRfcServerFunc (CSTR strFuncName, 
#ifdef SAPonNT
					bool bAutoCreate,
#else
                    BOOL bAutoCreate,
#endif
					const CRfcConnection* pServerConnection, CSTR strServerFuncName)
					:CRfcFunction (NULL, strFuncName),
					m_pServerApp(NULL),
					m_rstrServerFuncName(strServerFuncName),
					m_pServerConnection(pServerConnection),
					m_bServerParamsWereAutoCreated(FALSE)
{
		if (bAutoCreate == TRUE)
		{
			if (pServerConnection != NULL && strServerFuncName != NULL && strlen(strServerFuncName) != 0)
			{  //  Autocreate parameters at the beginning

				CRfcGetFunctionInterface *pGetFunctionInterface
					= new CRfcGetFunctionInterface(this, strServerFuncName, pServerConnection);

				if(!pGetFunctionInterface)
					throw AUTO_SERVER_CREATION_FAILURE_MSG;

				delete pGetFunctionInterface;

				m_bServerParamsWereAutoCreated = TRUE;		
			}
		}
}


CRfcServerFunc::~CRfcServerFunc() 
{
	if (m_bServerParamsWereAutoCreated == TRUE)
	{
		int i;
		for( i=0; i<m_Imports.GetSize(); i++ )
		{
			if (m_Imports[i] && m_Imports[i]->IsAutoCreated())
			{
				delete m_Imports[i];
			}
		}

		for( i=0; i<m_Exports.GetSize(); i++ )
		{
			if (m_Exports[i] && m_Exports[i]->IsAutoCreated())
			{
				delete m_Exports[i];
			}
		}
    
		for( i=0; i<m_Tables.GetSize(); i++ )
		{
			if (m_Tables[i] && m_Tables[i]->IsAutoCreated())
			{
				delete m_Tables[i];
			}
		}
	}
}


#if defined(CRFCwithTHREADS)
CRfcServerFunc * CRfcServerFunc::clone()
{
	char dbuf[1024];
	sprintf(dbuf, "\n\nYou have to implement this clone function CRfcServerFunc::clone() \n \
	in the derived class of CRfcServerFunc. \n \
    Suppose the derived class is Derived (: public CRfcServerFunc), \n \
	the clone function can then be defined in the following: \n \
    CRfcServerFunc * Dervied::clone() {return new Derived(*this);}.  \n \
	But it requires implementation of a copy constructor. \n \
    Derived::Derived(Derived & ).  \n \
	Therefore, in the derived class of CRfcServerFunc, \n \
	the copy constructor must be implemented. \n \
	Please see the multithreading server documentation and/or sample\n\n");
	RfcClassTrace.TraceTime();
 	RfcClassTrace.Trace(dbuf);
 	throw CRFCSERV_CLONE;
	return (CRfcServerFunc *)NULL;
}
#endif


CRfcServerFunc::CRfcServerFunc(const CRfcServerFunc& sourceServer)
: CRfcFunction(sourceServer)
{
	m_pServerApp = sourceServer.m_pServerApp;
	m_bServerParamsWereAutoCreated = sourceServer.m_bServerParamsWereAutoCreated;
	m_rstrServerFuncName = sourceServer.m_rstrServerFuncName;
	m_pServerConnection = sourceServer.m_pServerConnection;
}


CRfcServerFunc& CRfcServerFunc::operator=( const CRfcServerFunc& sourceServer )
{
	if( this== &sourceServer ) return *this;

	FreeCRfcFunction();
	CopyCRfcFunction(sourceServer);
	m_pServerApp = sourceServer.m_pServerApp;
	m_bServerParamsWereAutoCreated = sourceServer.m_bServerParamsWereAutoCreated;
	m_rstrServerFuncName = sourceServer.m_rstrServerFuncName;
	m_pServerConnection = sourceServer.m_pServerConnection;

	return *this;
}


RFC_RC CRfcServerFunc::Raise (char* strException)
{
	RFC_HANDLE RfcHandle = GetConnectionRfcHandle();
	if (RfcHandle == RFC_HANDLE_NULL)
		throw INVALID_RFC_HANDLE;
    
    return ::RfcRaise (RfcHandle, strException) ;
}


// Raise exceptions on the tables in the function
// The function itself may raise memory exception
RFC_RC CRfcServerFunc::RaiseTables (char* strException)
                                   
{
	RFC_HANDLE RfcHandle = GetConnectionRfcHandle();
	if (RfcHandle == RFC_HANDLE_NULL)
		throw INVALID_RFC_HANDLE;

    //SetUpTables () ;  // Have the RFC_TABLE structure filled      

    assert (m_pTabStructs != NULL);
	if (m_pTabStructs == NULL)
		throw MEMORY;

    return ::RfcRaiseTables (RfcHandle, strException, m_pTabStructs); 
}

void CRfcServerFunc::Process()
{
}

char* CRfcServerFunc::GetDescription (void)
{
    return NULL ;
}



// Retrieving data after a function call
// may raise RFC_ERROR_INFO_EX or memory exceptions 
// when executing RfcGetData 
RFC_RC CRfcServerFunc::ReceiveData (void)
{
    RFC_RC     rc; 
	RFC_HANDLE RfcHandle = GetConnectionRfcHandle();
	if (RfcHandle == RFC_HANDLE_NULL)
		throw INVALID_RFC_HANDLE;
   
    //Setup RFC import parameter and table parameter structure
    SetUpImports (TRUE);
    SetUpTables (); 

    assert (m_pImpStructs != NULL) ;
    assert (m_pTabStructs != NULL) ;

	if (m_pImpStructs == NULL || m_pTabStructs == NULL)
		throw MEMORY;

	int i;

	for (i = 0; i < GetTableCount(); i++)
	{
		m_pTabStructs[i].ithandle = ITAB_NULL;
	}

    //Get data from the RFC connection
    rc = ::RfcGetData (RfcHandle, 
                       m_pImpStructs, 
                       m_pTabStructs) ;

    if (rc != RFC_OK)
    {
        CRFC_ERROR_INFO err;
        //Find out the error
        ::RfcLastErrorEx (&err);
		::RfcLastError (&err);
        RfcClassTrace.TraceTime();
        RfcClassTrace.Trace(CRFCSERV_RECEIVEDATA);
        RfcClassTrace.TraceRFCErrorInfo((RFC_ERROR_INFO_EX) err);
        throw err ;
    }

    ExtractTables() ;
    return rc ;
}


// Retrieving data after a function call
// may raise RFC_ERROR_INFO_EX or memory exceptions 
// when executing RfcSendData
RFC_RC CRfcServerFunc::ReturnCall  (void)
{
    RFC_RC     rc; 
    
	RFC_HANDLE RfcHandle = GetConnectionRfcHandle();
	if (RfcHandle == RFC_HANDLE_NULL)
		throw INVALID_RFC_HANDLE;
   
    //Setup RFC export parameter and table parameter structure
    SetUpExports ();
    //SetUpTables (); 

    assert (m_pExpStructs != NULL) ;
    assert (m_pTabStructs != NULL) ;

	if (m_pExpStructs == NULL || m_pTabStructs == NULL)
		throw MEMORY;

    //Get data from the RFC connection
    rc = ::RfcSendData (RfcHandle, 
                        m_pExpStructs, 
                        m_pTabStructs) ;

    if (rc != RFC_OK)
    {
        CRFC_ERROR_INFO err;
        //Find out the error
        ::RfcLastErrorEx (&err);
		::RfcLastError (&err);
        RfcClassTrace.TraceTime();
        RfcClassTrace.Trace(CRFCSERV_RETURNCALL);
        RfcClassTrace.TraceRFCErrorInfo((RFC_ERROR_INFO_EX) err);
        throw err ;
    }

    CRfcFunction::ExtractTables();
    return rc ;
}

#if defined(CRFCwithTHREADS)
//  Get data, process data, and then send data to the calling client.

void CRfcServerFunc::MultipleThreadDataProcess(void)
{
	try
	{
		ReceiveData ();
			CRfcConnection * pConnection = (CRfcConnection *) m_pConnection;
		if((pConnection != NULL) &&
			(pConnection->GetConnectInfo()->rstrR3release == RELEASEUNKNOWN))
		{
			pConnection->GetR3Release();
			if(pConnection->GetConnectInfo()->bGetR3SystemInfo)
				pConnection->GetR3SystemInfo();
		}
		Process ();
		ReturnCall ();
	} 
	catch (char * pException)
	{
		printf(" CRfcServerFunc::MultipleThreadDataProcess %s\n", pException);
	} 
	catch (RFC_ERROR_INFO & err)
	{
		DumpRFCErrorInfo(err);
	}
	delete this;
}
#endif
//  The following CallReceive function is used to communicate with R/3 system
//  and get the data from the R/3 system.  It is not used to communicate with 
//  the the RFC client calling this RFC server.  There are two RFC connections
//  in the auto creating RFC servers.  One is used to listen to the RFC clients
//  and the other is used to get the RFC function metadata from some R/3 system.


RFC_RC CRfcServerFunc::CallReceive(char*& strException, BOOL bPassAllParams)
{
    RFC_HANDLE RfcHandle = RFC_HANDLE_NULL;

	if(m_pServerConnection)
		RfcHandle = m_pServerConnection->GetHandle();

    RfcClassTrace.TraceTime();
    RfcClassTrace.Trace(CRFCSERV_CALLRECEIVE);
    RfcClassTrace.Trace(CSTR(m_rstrServerFuncName));

    //Setup RFC import, export parameter and table parameter structure
    SetUpImports(bPassAllParams);
    SetUpExports();
    SetUpTables();
  
    assert (m_pImpStructs != NULL) ;
    assert (m_pExpStructs != NULL) ;
    assert (m_pTabStructs != NULL) ;

	if (m_pImpStructs == NULL || m_pExpStructs == NULL || m_pTabStructs == NULL)
		throw MEMORY;

    //check to make sure all tables have valid handles
    CheckTables();

/*
    RFC_RC rc = ::RfcCallReceive(RfcHandle, 
                                 (char*)(CSTR(m_rstrServerFuncName)), 
                                 m_pImpStructs,
                                 m_pExpStructs, 
                                 m_pTabStructs,
                                 &strException);
*/
    RFC_RC rc = ::RfcCall(RfcHandle, 
                          (char*)(CSTR(m_rstrServerFuncName)), 
                          m_pImpStructs, 
                          m_pTabStructs);

    if( rc != RFC_OK )
    {
        CRFC_ERROR_INFO errorInfo;
        ::RfcLastErrorEx(&errorInfo);
		::RfcLastError(&errorInfo);
        RfcClassTrace.TraceTime();
        RfcClassTrace.Trace(CRFCSERV_CALLRECEIVE);
        RfcClassTrace.Trace(CSTR(m_rstrServerFuncName));
        throw errorInfo;
    }


    rc = ::RfcReceive(RfcHandle, 
                      m_pExpStructs, 
                      m_pTabStructs,
                      &strException);
	if (rc == RFC_EXCEPTION)
		return rc;

	if (rc == RFC_OK || rc == RFC_CALL)
	{
		ExtractTables();
		ConvertExports();
		return rc; 
	}

	if (rc == RFC_FAILURE || rc == RFC_SYS_EXCEPTION || rc == RFC_CLOSED)
	{
		CRFC_ERROR_INFO errorInfo;
        ::RfcLastErrorEx(&errorInfo);
		::RfcLastError(&errorInfo);
        RfcClassTrace.TraceTime();
        RfcClassTrace.Trace(CRFCSERV_CALLRECEIVE);
        RfcClassTrace.Trace(CSTR(m_rstrServerFuncName));
        throw errorInfo;		
	}
	return rc;
}    

